﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Pc.Shared.Barcode.Services;
using Pc.Shared.Utils.Collections;
using System.Xml.Linq;

namespace barcode.test.net
{
  class Program
  {
    static void Main(string[] args) {
      //Данные штрих-кода полученные со сканера
      CByte barcode_data_V1 = "010016E959AF0F3A6C53E684D37771CEEF39DF38711DE4FCD27685DF35419C03000000000000000000000000000000000000000271D3000000EF4A04BDB800F618017DDE3F6B9C4B4592FB28EB75EF1E0D2274BD0F57377284F02469698A8CAC4A912FE74D773AF6FC0C8D71515CB88176EC04A414B179AD00AC548295033972DC82";
      CByte barcode_data_V2 = "0200000000363D804E9DB3A17503BF84E869B9C3BF39C3A175AA5341C3800000000000000000000000000000000000000000000000000000000000000283EB0000015CEA680D9CDDEF0209E9F91FFEA628328CD157144B634204BAC30F573FF2E1021BDC2A28B2DD50A2761E4CF75FFCDBFBA71EAFC548AD07D38DC82A7D674BD09A";
      //Объект для конвертирования упакованонного штрих-кода в строку формата XML
      BarcodeService service = new BarcodeService();
      //Коневртирование
      string converted_barcode_V1 = service.DecomposeBarcode(barcode_data_V1);
      //Вывод строки на консоль
      printf("Тип 1");
      printobj(converted_barcode_V1);
      //Коневртирование
      string converted_barcode_V2 = service.DecomposeBarcode(barcode_data_V2);
      //Вывод строки на консоль
      printf("Тип 2");
      printobj(converted_barcode_V2);
    }

    static void printobj(string xml) {
      XElement root = XElement.Parse(xml);
      printf("Тип штрих-кода:         {0}", getByte(root.Element("BarcodeType")));
      printf("Номер полиса ОМС:       {0:D16}", getUlong(root.Element("PolicyNumber")));
      printf("Фамилия:                {0}", root.Element("LastName").Value);
      printf("Имя:                    {0}", root.Element("FirstName").Value);
      printf("Отчество:               {0}", root.Element("Patronymic").Value);
      printf("Дата рождения:          {0:dd.MM.yyyy}", getDate(root.Element("BirthDate")));
      printf("Срок действия полиса    {0:dd.MM.yyyy}", getDate(root.Element("ExpireDate")));
      printf("Пол                     {0}", getByte(root.Element("Sex")) == 1 ? "Мужской" : "Женский");
    }

    static void printf(string format, params object[] args) {
      Console.WriteLine(format, args);
    }

    static byte getByte(XElement value)
    {
      return byte.Parse(value.Value);
    }

    static ulong getUlong(XElement value)
    {
      return ulong.Parse(value.Value);
    }

    static DateTime getDate(XElement value)
    {
      return DateTime.Parse(value.Value);
    }
  }
}